from scorer_utils import *
import os
import json
# from abstention_detector import AbstentionScorer


class HistoricalScorer:
    def __init__(self, json_path):
        self.json_path = json_path
        self.data = self._read_json()
        # self.abstention_scorer = AbstentionScorer()

    def _read_json(self):
        with open(self.json_path, 'r') as f:
            return json.load(f)

    def compute_scores(self):
        for data in self.data:
            for prompt, entry in data.items():
                self._add_entry_scores(entry)
        return self.data

    def _add_entry_scores(self, entry):
        response = entry.get("response", "")
        verified_response = entry.get("parsed_response", "")

        abstention = ("no" in verified_response.lower()
            or response.strip() == ""
        )

        if abstention:
            hallucination_score = 0.0
            response_ratio = 0.0
            utility_score = 1.0
        else:
            hallucination_score = 1.0
            response_ratio = 1.0
            utility_score = 0.0

        entry['scores'] = {
            'hallucination_score': hallucination_score,
            'response_ratio': response_ratio,
            'utility_score': utility_score
        }


if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser(description="Score historical event responses using response-level JSON.")
    parser.add_argument("--input_dir", help="Path to folder with input .json files", required=True)
    parser.add_argument("--output_dir", help="Path to folder for output .json files", required=True)
    args = parser.parse_args()

    os.makedirs(args.output_dir, exist_ok=True)

    for filename in os.listdir(args.input_dir):
        if filename.endswith(".json"):
            input_path = os.path.join(args.input_dir, filename)
            scorer = HistoricalScorer(input_path)
            scored_data = scorer.compute_scores()

            output_path = os.path.join(args.output_dir, filename)
            with open(output_path, 'w') as f:
                json.dump(scored_data, f, indent=4)

            print(f"Scored file saved to {output_path}")